@echo off
setlocal enabledelayedexpansion
chcp 65001 >nul
title Mintos Injector - Installer
color 0A

echo.
echo ========================================
echo   MINTOS INJECTOR - Auto Installer
echo ========================================
echo.

:: Check if Node.js is installed
where node >nul 2>&1
if %ERRORLEVEL% EQU 0 (
    for /f "tokens=*" %%v in ('node -v') do set "NODE_VER=%%v"
    echo [OK] Node.js found: !NODE_VER!
    goto :npm_install
)

echo [!!] Node.js not found. Installing...
echo.

:: Detect architecture
if "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
    set "ARCH=x64"
) else (
    set "ARCH=x86"
)

:: Download Node.js v20 LTS using PowerShell
set "NODE_URL=https://nodejs.org/dist/v20.18.0/node-v20.18.0-%ARCH%.msi"
set "NODE_MSI=%TEMP%\node-installer.msi"

echo Downloading Node.js v20 LTS (%ARCH%)...
powershell -Command "& { [Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; Invoke-WebRequest -Uri '%NODE_URL%' -OutFile '%NODE_MSI%' -UseBasicParsing }" 2>nul

if not exist "%NODE_MSI%" (
    echo [ERROR] Failed to download Node.js!
    echo Please install Node.js manually from https://nodejs.org
    pause
    exit /b 1
)

echo Installing Node.js (this may take a minute)...
msiexec /i "%NODE_MSI%" /qn /norestart

:: Wait for installation
timeout /t 5 /nobreak >nul

:: Refresh PATH
set "PATH=%PATH%;C:\Program Files\nodejs;C:\Program Files (x86)\nodejs"

:: Verify
where node >nul 2>&1
if %ERRORLEVEL% NEQ 0 (
    echo [ERROR] Node.js installation failed!
    echo Please install manually from https://nodejs.org then run this again.
    pause
    exit /b 1
)

for /f "tokens=*" %%v in ('node -v') do set "NODE_VER=%%v"
echo [OK] Node.js installed: !NODE_VER!

:: Clean up installer
del "%NODE_MSI%" >nul 2>&1

:npm_install
echo.
echo Installing dependencies...
cd /d "%~dp0"
call npm install --production 2>nul
if %ERRORLEVEL% NEQ 0 (
    echo [ERROR] npm install failed!
    pause
    exit /b 1
)
echo [OK] Dependencies installed!

:: Create answer-db.json if it doesn't exist
if not exist "answer-db.json" (
    echo {} > answer-db.json
)

echo.
echo ========================================
echo   INSTALLATION COMPLETE!
echo ========================================
echo.
echo   Run "inject.bat" to start mining.
echo.
echo   You will need a license key.
echo   Contact the admin to get one.
echo.
echo ========================================
echo.
pause
